<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;

/**
 * LicenZer master display controller.
 */
class LicenzerController extends BaseController
{
    /**
     * The default view.
     */
    protected $default_view = 'dashboard';

    /**
     * Method to display a view.
     */
    public function display($cachable = false, $urlparams = array())
    {
        $view   = $this->input->get('view', 'dashboard');
        $layout = $this->input->get('layout', 'default');
        $id     = $this->input->getInt('id');

        // Check for edit form.
        if ($view == 'license' && $layout == 'edit' && !$this->checkEditId('com_licenzer.edit.license', $id))
        {
            // Somehow the person just went to the form - we don't allow that.
            $this->setError(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id));
            $this->setMessage($this->getError(), 'error');
            $this->setRedirect(Route::_('index.php?option=com_licenzer&view=licenses', false));

            return false;
        }

        return parent::display();
    }
}

