<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;

// Access check.
if (!Factory::getUser()->authorise('core.manage', 'com_licenzer'))
{
    throw new Exception(Text::_('JERROR_ALERTNOAUTHOR'), 403);
}

// Register helper class
JLoader::register('LicenzerHelper', JPATH_ADMINISTRATOR . '/components/com_licenzer/helpers/licenzer.php');

// Execute the task.
$controller = BaseController::getInstance('Licenzer');
$controller->execute(Factory::getApplication()->input->get('task'));
$controller->redirect();

