<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\BaseDatabaseModel;

JLoader::register('LicenzerApiHelper', JPATH_ADMINISTRATOR . '/components/com_licenzer/helpers/api.php');

/**
 * Dashboard model.
 */
class LicenzerModelDashboard extends BaseDatabaseModel
{
    /**
     * Get statistics
     */
    public function getStatistics()
    {
        $api = new LicenzerApiHelper();
        $licenses = $api->getLicenses();
        
        $stats = array(
            'total' => 0,
            'active' => 0,
            'inactive' => 0,
            'discount' => 0,
            'balance' => 0,
        );

        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $license_list = $licenses['data'] ?? array();
            $stats['total'] = count($license_list);
            
            foreach ($license_list as $license) {
                if (isset($license['status']) && $license['status'] == 1) {
                    $stats['active']++;
                } else {
                    $stats['inactive']++;
                }
            }
        }

        $discount_licenses = $api->getDiscountLicenses();
        if (isset($discount_licenses['status']) && $discount_licenses['status'] == 'success') {
            $stats['discount'] = count($discount_licenses['data'] ?? array());
        }

        $balance = $api->getBalance();
        if (isset($balance['status']) && $balance['status'] == 'success') {
            $stats['balance'] = floatval($balance['data'] ?? 0);
        }

        return $stats;
    }

    /**
     * Get recent licenses
     */
    public function getRecentLicenses($limit = 10)
    {
        $api = new LicenzerApiHelper();
        $licenses = $api->getLicenses();
        
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $license_list = $licenses['data'] ?? array();
            return array_slice($license_list, 0, $limit);
        }

        return array();
    }
}

