<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\FormModel;
use Joomla\CMS\Factory;

JLoader::register('LicenzerApiHelper', JPATH_ADMINISTRATOR . '/components/com_licenzer/helpers/api.php');

/**
 * Settings model.
 */
class LicenzerModelSettings extends FormModel
{
    /**
     * Method to get the record form.
     */
    public function getForm($data = array(), $loadData = true)
    {
        $form = $this->loadForm('com_licenzer.settings', 'settings', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form))
        {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     */
    protected function loadFormData()
    {
        $app = Factory::getApplication();
        $data = $app->getUserState('com_licenzer.edit.settings.data', array());

        if (empty($data))
        {
            $component = JComponentHelper::getComponent('com_licenzer');
            $data = $component->params->toArray();
        }

        return $data;
    }

    /**
     * Test API connection
     */
    public function testConnection()
    {
        $api = new LicenzerApiHelper();
        return $api->testConnection();
    }
}

