<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$app = Factory::getApplication();
$user = Factory::getUser();

$model = $this->getModel();
$stats = $model->getStatistics();
$recentLicenses = $model->getRecentLicenses();

ToolbarHelper::title(Text::_('COM_LICENZER_DASHBOARD'), 'dashboard');
ToolbarHelper::preferences('com_licenzer');

LicenzerHelper::addSubmenu('dashboard');
?>

<div class="row-fluid">
    <div id="j-main-container" class="span10">
        <div class="licenzer-dashboard">
            <!-- Statistics -->
            <div class="row-fluid">
                <div class="span3">
                    <div class="stat-box stat-primary">
                        <div class="stat-icon">
                            <span class="icon-network"></span>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo $stats['total']; ?></h3>
                            <p><?php echo Text::_('COM_LICENZER_TOTAL_LICENSES'); ?></p>
                        </div>
                    </div>
                </div>
                <div class="span3">
                    <div class="stat-box stat-success">
                        <div class="stat-icon">
                            <span class="icon-checkmark"></span>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo $stats['active']; ?></h3>
                            <p><?php echo Text::_('COM_LICENZER_ACTIVE_LICENSES'); ?></p>
                        </div>
                    </div>
                </div>
                <div class="span3">
                    <div class="stat-box stat-warning">
                        <div class="stat-icon">
                            <span class="icon-tag"></span>
                        </div>
                        <div class="stat-content">
                            <h3><?php echo $stats['discount']; ?></h3>
                            <p><?php echo Text::_('COM_LICENZER_DISCOUNT_LICENSES'); ?></p>
                        </div>
                    </div>
                </div>
                <div class="span3">
                    <div class="stat-box stat-info">
                        <div class="stat-icon">
                            <span class="icon-money"></span>
                        </div>
                        <div class="stat-content">
                            <h3>$<?php echo number_format($stats['balance'], 2); ?></h3>
                            <p><?php echo Text::_('COM_LICENZER_BALANCE'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="row-fluid" style="margin-top: 20px;">
                <div class="span12">
                    <div class="well">
                        <h3><?php echo Text::_('COM_LICENZER_QUICK_ACTIONS'); ?></h3>
                        <a href="<?php echo Route::_('index.php?option=com_licenzer&view=licenses'); ?>" class="btn btn-primary">
                            <?php echo Text::_('COM_LICENZER_VIEW_ALL_LICENSES'); ?>
                        </a>
                        <a href="<?php echo Route::_('index.php?option=com_licenzer&view=discount'); ?>" class="btn">
                            <?php echo Text::_('COM_LICENZER_MANAGE_DISCOUNT'); ?>
                        </a>
                        <a href="<?php echo Route::_('index.php?option=com_licenzer&view=settings'); ?>" class="btn">
                            <?php echo Text::_('COM_LICENZER_SETTINGS'); ?>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Recent Licenses -->
            <?php if (!empty($recentLicenses)): ?>
            <div class="row-fluid" style="margin-top: 20px;">
                <div class="span12">
                    <h3><?php echo Text::_('COM_LICENZER_RECENT_LICENSES'); ?></h3>
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo Text::_('COM_LICENZER_LICENSE_KEY'); ?></th>
                                <th><?php echo Text::_('COM_LICENZER_IP_ADDRESS'); ?></th>
                                <th><?php echo Text::_('COM_LICENZER_SOFTWARE'); ?></th>
                                <th><?php echo Text::_('COM_LICENZER_STATUS'); ?></th>
                                <th><?php echo Text::_('COM_LICENZER_EXPIRY_DATE'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentLicenses as $license): ?>
                            <tr>
                                <td><code><?php echo htmlspecialchars($license['license_key'] ?? 'N/A'); ?></code></td>
                                <td><?php echo htmlspecialchars($license['ip'] ?? 'N/A'); ?></td>
                                <td><?php echo htmlspecialchars($license['software_name'] ?? $license['key'] ?? 'N/A'); ?></td>
                                <td>
                                    <span class="label label-<?php echo ($license['status'] ?? 0) ? 'success' : 'important'; ?>">
                                        <?php echo ($license['status'] ?? 0) ? Text::_('COM_LICENZER_ACTIVE') : Text::_('COM_LICENZER_INACTIVE'); ?>
                                    </span>
                                </td>
                                <td><?php echo htmlspecialchars($license['end_at'] ?? $license['Expired date'] ?? 'N/A'); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <div id="sidebar" class="span2">
        <?php echo HTMLHelper::_('sidebar.render'); ?>
    </div>
</div>

