<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$app = Factory::getApplication();
$user = Factory::getUser();

$form = $this->get('Form');
$model = $this->getModel();
$connectionStatus = $model->testConnection();

ToolbarHelper::title(Text::_('COM_LICENZER_SUBMENU_SETTINGS'), 'options');
ToolbarHelper::apply('settings.apply');
ToolbarHelper::save('settings.save');
ToolbarHelper::preferences('com_licenzer');

LicenzerHelper::addSubmenu('settings');
?>

<div class="row-fluid">
    <div id="j-main-container" class="span10">
        <form action="<?php echo Route::_('index.php?option=com_licenzer&view=settings'); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">
            <div class="form-horizontal">
                <?php echo $form->renderFieldset('basic'); ?>
                
                <div class="control-group">
                    <div class="control-label">
                        <label><?php echo Text::_('COM_LICENZER_API_STATUS'); ?></label>
                    </div>
                    <div class="controls">
                        <?php if ($connectionStatus): ?>
                            <span class="label label-success"><?php echo Text::_('COM_LICENZER_CONNECTED'); ?></span>
                        <?php else: ?>
                            <span class="label label-important"><?php echo Text::_('COM_LICENZER_DISCONNECTED'); ?></span>
                            <p class="help-block"><?php echo Text::_('COM_LICENZER_CHECK_SETTINGS'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <input type="hidden" name="task" value="" />
            <?php echo HTMLHelper::_('form.token'); ?>
        </form>
    </div>
    <div id="sidebar" class="span2">
        <?php echo HTMLHelper::_('sidebar.render'); ?>
    </div>
</div>

