# LicenZer Laravel Package

پکیج Laravel برای مدیریت و فروش لایسنس‌های LicenZer

## نصب

### 1. نصب از طریق Composer

```bash
composer require licenzer/licenzer-laravel
```

یا اگر فایل‌ها را به صورت دستی اضافه می‌کنید:

```bash
composer require licenzer/licenzer-laravel --no-scripts
```

### 2. Publish Configuration

```bash
php artisan vendor:publish --tag=licenzer-config
```

### 3. تنظیمات Environment

فایل `.env` را ویرایش کنید:

```env
LICENZER_API_URL=https://licenzer.pro
LICENZER_RESELLER_TOKEN=your_reseller_token_here
LICENZER_ALLOW_IP_CHANGE=true
LICENZER_MAX_IP_CHANGES=0
LICENZER_ENABLE_DISCOUNT=true
```

### 4. اجرای Migration

```bash
php artisan migrate
```

### 5. Middleware (اختیاری)

اگر از middleware `admin` استفاده می‌کنید، باید آن را در `app/Http/Kernel.php` تعریف کنید:

```php
protected $routeMiddleware = [
    // ...
    'admin' => \App\Http\Middleware\AdminMiddleware::class,
];
```

## استفاده

### Routes

پکیج به صورت خودکار route‌های زیر را ثبت می‌کند:

**Admin Routes:**
- `GET /licenzer/admin/dashboard` - Dashboard
- `GET /licenzer/admin/licenses` - لیست لایسنس‌ها
- `POST /licenzer/admin/licenses/change-ip` - تغییر IP
- `GET /licenzer/admin/discount` - لایسنس‌های تخفیف‌دار
- `GET /licenzer/admin/settings` - تنظیمات
- `POST /licenzer/admin/settings` - به‌روزرسانی تنظیمات

**Customer Routes:**
- `GET /licenzer/customer/licenses` - لایسنس‌های مشتری
- `POST /licenzer/customer/licenses/change-ip` - تغییر IP (AJAX)

### استفاده از API

```php
use Licenzer\Licenzer\LicenzerApi;

$api = app('licenzer.api');

// دریافت لیست لایسنس‌ها
$licenses = $api->getLicenses();

// ثبت لایسنس جدید
$result = $api->registerLicense('192.168.1.1', 1, 'software_key');

// تغییر IP
$result = $api->changeIp('192.168.1.1', '192.168.1.2', 'software_key');

// دریافت لایسنس‌های تخفیف‌دار
$discountLicenses = $api->getDiscountLicenses();
```

### استفاده از Model

```php
use Licenzer\Licenzer\Models\License;

// دریافت لایسنس‌های یک کاربر
$licenses = License::where('user_id', auth()->id())->get();

// ایجاد لایسنس جدید
License::create([
    'user_id' => auth()->id(),
    'license_key' => 'xxx-xxx-xxx',
    'ip_address' => '192.168.1.1',
    'software_key' => 'software_key',
    'software_name' => 'Software Name',
    'status' => true,
    'expiry_date' => now()->addMonth(),
]);
```

## ساختار فایل‌ها

```
laravel-licenzer-package/
├── src/
│   ├── LicenzerServiceProvider.php
│   ├── LicenzerApi.php
│   ├── Controllers/
│   │   ├── Admin/
│   │   │   ├── DashboardController.php
│   │   │   ├── LicenseController.php
│   │   │   ├── DiscountController.php
│   │   │   └── SettingsController.php
│   │   └── Customer/
│   │       └── LicenseController.php
│   └── Models/
│       └── License.php
├── config/
│   └── licenzer.php
├── database/
│   └── migrations/
│       └── 2024_01_01_000000_create_licenzer_licenses_table.php
├── resources/
│   └── views/
│       ├── layouts/
│       │   ├── admin.blade.php
│       │   └── customer.blade.php
│       ├── admin/
│       │   ├── dashboard.blade.php
│       │   ├── licenses.blade.php
│       │   ├── discount.blade.php
│       │   └── settings.blade.php
│       └── customer/
│           └── licenses.blade.php
└── composer.json
```

## نیازمندی‌ها

- Laravel 9.x, 10.x, or 11.x
- PHP 8.0 یا بالاتر
- Guzzle HTTP Client
- دسترسی به API سیستم LicenZer
- توکن نمایندگی معتبر

## ویژگی‌ها

- ✅ Dashboard با آمار کامل
- ✅ مدیریت لایسنس‌ها
- ✅ تغییر IP لایسنس
- ✅ لایسنس‌های تخفیف‌دار
- ✅ تنظیمات کامل
- ✅ بخش مشتری
- ✅ API Helper
- ✅ Model برای دیتابیس

## توسعه در آینده

- یکپارچگی با سیستم پرداخت Laravel
- Event Listener برای ثبت خودکار لایسنس
- Notification برای اعلان‌ها
- API Resource برای JSON responses
- Command Line Tools

