<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('licenzer_licenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('order_id')->nullable();
            $table->string('license_key')->unique();
            $table->string('ip_address', 45);
            $table->string('software_key', 100);
            $table->string('software_name')->nullable();
            $table->boolean('status')->default(true);
            $table->date('expiry_date')->nullable();
            $table->integer('ip_changes')->default(0);
            $table->integer('max_ip_changes')->default(0);
            $table->boolean('is_discount')->default(false);
            $table->timestamps();

            $table->index('user_id');
            $table->index('license_key');
            $table->index('order_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('licenzer_licenses');
    }
};

