@extends('licenzer::layouts.admin')

@section('title', 'Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1>LicenZer Dashboard</h1>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title">Total Licenses</h5>
                            <h2 class="mb-0">{{ $stats['total'] }}</h2>
                        </div>
                        <i class="fas fa-key fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title">Active Licenses</h5>
                            <h2 class="mb-0">{{ $stats['active'] }}</h2>
                        </div>
                        <i class="fas fa-check-circle fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title">Discount Licenses</h5>
                            <h2 class="mb-0">{{ $stats['discount'] }}</h2>
                        </div>
                        <i class="fas fa-tag fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title">Balance</h5>
                            <h2 class="mb-0">${{ number_format($stats['balance'], 2) }}</h2>
                        </div>
                        <i class="fas fa-dollar-sign fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <a href="{{ route('licenzer.admin.licenses') }}" class="btn btn-primary">
                        <i class="fas fa-list"></i> View All Licenses
                    </a>
                    <a href="{{ route('licenzer.admin.discount') }}" class="btn btn-success">
                        <i class="fas fa-tag"></i> Manage Discount Licenses
                    </a>
                    <a href="{{ route('licenzer.admin.settings') }}" class="btn btn-info">
                        <i class="fas fa-cog"></i> Settings
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Licenses -->
    @if(!empty($recentLicenses))
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Recent Licenses</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>License Key</th>
                                    <th>IP Address</th>
                                    <th>Software</th>
                                    <th>Status</th>
                                    <th>Expiry Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentLicenses as $license)
                                <tr>
                                    <td><code>{{ $license['license_key'] ?? 'N/A' }}</code></td>
                                    <td>{{ $license['ip'] ?? 'N/A' }}</td>
                                    <td>{{ $license['software_name'] ?? $license['key'] ?? 'N/A' }}</td>
                                    <td>
                                        @if($license['status'] ?? 0)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $license['end_at'] ?? $license['Expired date'] ?? 'N/A' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

