@extends('licenzer::layouts.admin')

@section('title', 'Discount Licenses')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1>Discount Licenses</h1>
        </div>
    </div>

    <div class="alert alert-info">
        <strong>Discount Licenses</strong><br>
        These are licenses that were previously activated and are now available for resale at 50% discount with no setup cost.
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if(!empty($licenseList))
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>License Key</th>
                                    <th>Software</th>
                                    <th>IP Address</th>
                                    <th>Original Price</th>
                                    <th>Discount Price</th>
                                    <th>Expiry Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($licenseList as $license)
                                <tr>
                                    <td><code>{{ $license['license_key'] ?? 'N/A' }}</code></td>
                                    <td>{{ $license['software_name'] ?? 'N/A' }}</td>
                                    <td>{{ $license['ip'] ?? 'N/A' }}</td>
                                    <td><del>${{ number_format($license['original_price'] ?? 0, 2) }}</del></td>
                                    <td><strong class="text-success">${{ number_format($license['price'] ?? 0, 2) }}</strong></td>
                                    <td>{{ $license['expiry_date'] ?? 'N/A' }}</td>
                                    <td>
                                        <button type="button" class="btn btn-primary btn-sm assign-license-btn"
                                                data-license-key="{{ $license['license_key'] ?? '' }}"
                                                data-ip="{{ $license['ip'] ?? '' }}">
                                            <i class="fas fa-check"></i> Assign
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="alert alert-warning">
                        No discount licenses available at this time.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

