@extends('licenzer::layouts.customer')

@section('title', 'My Licenses')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <h1>My Licenses</h1>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if($licenses->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>License Key</th>
                                    <th>IP Address</th>
                                    <th>Software</th>
                                    <th>Status</th>
                                    <th>Expiry Date</th>
                                    @if($allowIpChange)
                                    <th>Actions</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($licenses as $license)
                                <tr>
                                    <td><code>{{ $license->license_key }}</code></td>
                                    <td>{{ $license->ip_address }}</td>
                                    <td>{{ $license->software_name }}</td>
                                    <td>
                                        @if($license->status)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $license->expiry_date ? $license->expiry_date->format('Y-m-d') : 'N/A' }}</td>
                                    @if($allowIpChange)
                                    <td>
                                        <button type="button" class="btn btn-warning btn-sm change-ip-btn"
                                                data-license-key="{{ $license->license_key }}"
                                                data-current-ip="{{ $license->ip_address }}">
                                            <i class="fas fa-exchange-alt"></i> Change IP
                                        </button>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="alert alert-info">
                        You don't have any licenses yet.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@if($allowIpChange)
<!-- Change IP Modal -->
<div class="modal fade" id="changeIpModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="change-ip-form">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Change IP Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="license_key" id="modal-license-key">
                    
                    <div class="mb-3">
                        <label class="form-label">Current IP</label>
                        <input type="text" id="modal-current-ip-display" class="form-control" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="new-ip" class="form-label">New IP Address</label>
                        <input type="text" name="new_ip" id="new-ip" class="form-control" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Change IP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const changeIpButtons = document.querySelectorAll('.change-ip-btn');
    const modal = new bootstrap.Modal(document.getElementById('changeIpModal'));
    const form = document.getElementById('change-ip-form');

    changeIpButtons.forEach(button => {
        button.addEventListener('click', function() {
            document.getElementById('modal-license-key').value = this.dataset.licenseKey;
            document.getElementById('modal-current-ip-display').value = this.dataset.currentIp;
            modal.show();
        });
    });

    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        fetch('{{ route("licenzer.customer.licenses.changeIp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({
                license_key: document.getElementById('modal-license-key').value,
                new_ip: document.getElementById('new-ip').value
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.success);
                modal.hide();
                location.reload();
            } else if (data.error) {
                alert(data.error);
            }
        })
        .catch(error => {
            alert('An error occurred');
        });
    });
});
</script>
@endif
@endsection

