<?php

namespace Licenzer\Licenzer\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Licenzer\Licenzer\LicenzerApi;

class DashboardController extends Controller
{
    private $api;

    public function __construct()
    {
        $this->api = app('licenzer.api');
    }

    public function index()
    {
        $licenses = $this->api->getLicenses();
        $discountLicenses = $this->api->getDiscountLicenses();
        $balance = $this->api->getBalance();

        $stats = [
            'total' => 0,
            'active' => 0,
            'inactive' => 0,
            'discount' => 0,
            'balance' => 0,
        ];

        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $licenseList = $licenses['data'] ?? [];
            $stats['total'] = count($licenseList);

            foreach ($licenseList as $license) {
                if (isset($license['status']) && $license['status'] == 1) {
                    $stats['active']++;
                } else {
                    $stats['inactive']++;
                }
            }
        }

        if (isset($discountLicenses['status']) && $discountLicenses['status'] == 'success') {
            $stats['discount'] = count($discountLicenses['data'] ?? []);
        }

        if (isset($balance['status']) && $balance['status'] == 'success') {
            $stats['balance'] = floatval($balance['data'] ?? 0);
        }

        $recentLicenses = [];
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $recentLicenses = array_slice($licenses['data'] ?? [], 0, 10);
        }

        return view('licenzer::admin.dashboard', compact('stats', 'recentLicenses'));
    }
}

