<?php

namespace Licenzer\Licenzer\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Licenzer\Licenzer\LicenzerApi;
use Licenzer\Licenzer\Models\License;

class LicenseController extends Controller
{
    private $api;

    public function __construct()
    {
        $this->api = app('licenzer.api');
    }

    public function index()
    {
        $licenses = License::where('user_id', auth()->id())->get();
        $allowIpChange = config('licenzer.allow_ip_change', false);

        return view('licenzer::customer.licenses', compact('licenses', 'allowIpChange'));
    }

    public function changeIp(Request $request)
    {
        if (!config('licenzer.allow_ip_change', false)) {
            return response()->json(['error' => 'IP change is not allowed'], 403);
        }

        $request->validate([
            'license_key' => 'required|string',
            'new_ip' => 'required|ip',
        ]);

        $license = License::where('license_key', $request->license_key)
            ->where('user_id', auth()->id())
            ->first();

        if (!$license) {
            return response()->json(['error' => 'License not found'], 404);
        }

        $maxChanges = config('licenzer.max_ip_changes', 0);
        if ($maxChanges > 0 && $license->ip_changes >= $maxChanges) {
            return response()->json(['error' => 'Maximum IP changes limit reached'], 403);
        }

        $result = $this->api->changeIp(
            $license->ip_address,
            $request->new_ip,
            $license->software_key
        );

        if (isset($result['status']) && $result['status'] == 'success') {
            $license->ip_address = $request->new_ip;
            $license->ip_changes++;
            $license->save();

            return response()->json(['success' => 'IP address changed successfully']);
        }

        return response()->json([
            'error' => $result['message'] ?? 'Failed to change IP address'
        ], 400);
    }
}

