<?php

namespace Licenzer\Licenzer\Models;

use Illuminate\Database\Eloquent\Model;

class License extends Model
{
    protected $fillable = [
        'user_id',
        'order_id',
        'license_key',
        'ip_address',
        'software_key',
        'software_name',
        'status',
        'expiry_date',
        'ip_changes',
        'max_ip_changes',
        'is_discount',
    ];

    protected $casts = [
        'status' => 'boolean',
        'is_discount' => 'boolean',
        'expiry_date' => 'date',
        'ip_changes' => 'integer',
        'max_ip_changes' => 'integer',
    ];

    /**
     * Get the user that owns the license
     */
    public function user()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
}

