# LicenZer OpenCart Module

ماژول OpenCart برای مدیریت و فروش لایسنس‌های LicenZer

## نصب

1. فایل‌های ماژول را در مسیر مناسب OpenCart کپی کنید:
   - `admin/` → `admin/`
   - `catalog/` → `catalog/`
   - `system/` → `system/`

2. فایل `install.sql` را در دیتابیس اجرا کنید

3. از پنل ادمین OpenCart به بخش **Extensions > Extensions > Modules** بروید

4. "LicenZer License Manager" را پیدا کنید و روی **Install** کلیک کنید

5. سپس روی **Edit** کلیک کنید و تنظیمات را پر کنید:
   - **API URL**: `https://licenzer.pro`
   - **Reseller Token**: توکن نمایندگی خود را وارد کنید
   - **Allow IP Change**: آیا کلاینت بتواند IP را تغییر دهد
   - **Max IP Changes**: تعداد مجاز تغییر IP (0 = نامحدود)
   - **Enable Discount Licenses**: فعال‌سازی لایسنس‌های تخفیف‌دار

6. ماژول را **Enable** کنید

## دسترسی به بخش‌های مختلف

بعد از نصب و فعال‌سازی، می‌توانید از لینک‌های زیر استفاده کنید:

- **Dashboard**: `index.php?route=extension/module/licenzer/dashboard`
- **All Licenses**: `index.php?route=extension/module/licenzer/licenses`
- **Discount Licenses**: `index.php?route=extension/module/licenzer/discount`
- **Settings**: `index.php?route=extension/module/licenzer`

## ویژگی‌ها

### Dashboard
- آمار کامل (Total Licenses, Active Licenses, Discount Licenses, Balance)
- لایسنس‌های اخیر
- Quick Actions

### All Licenses
- مشاهده لیست کامل تمام لایسنس‌ها
- تغییر IP لایسنس با Modal
- مشاهده جزئیات کامل

### Discount Licenses
- مشاهده لایسنس‌های تخفیف‌دار (50% تخفیف)
- اختصاص لایسنس به سفارش‌ها

### بخش مشتری (Customer Area)
- مشاهده لایسنس‌های خود
- تغییر IP (در صورت فعال بودن)
- مشاهده جزئیات لایسنس

## ساختار فایل‌ها

```
opencart-licenzer-module/
├── admin/
│   ├── controller/extension/module/licenzer.php
│   ├── model/extension/module/licenzer.php
│   ├── view/template/extension/module/
│   │   ├── licenzer.twig (Settings)
│   │   ├── licenzer_dashboard.twig
│   │   ├── licenzer_licenses.twig
│   │   └── licenzer_discount.twig
│   └── language/en-gb/extension/module/licenzer.php
├── catalog/
│   ├── controller/account/licenzer.php
│   ├── model/account/licenzer.php
│   ├── view/theme/default/template/account/licenzer.twig
│   └── language/en-gb/account/licenzer.php
├── system/
│   └── library/licenzer_api.php
├── install.sql
├── uninstall.sql
└── install.xml
```

## نیازمندی‌ها

- OpenCart 3.x
- PHP 7.2 یا بالاتر
- دسترسی به API سیستم LicenZer
- توکن نمایندگی معتبر

## توسعه در آینده

- یکپارچگی با سیستم پرداخت OpenCart
- ایجاد خودکار لایسنس هنگام ثبت سفارش
- اعلان‌های ایمیل
- ماژول نمایش لایسنس‌ها در صفحه محصول

