# LicenZer PHP Script

اسکریپت PHP مستقل برای مدیریت لایسنس‌های LicenZer

## نصب

1. فایل `licenzer.php` را دانلود کنید
2. فایل را در مسیر مورد نظر خود قرار دهید
3. تنظیمات را ویرایش کنید:

```php
define('LICENZER_API_URL', 'https://licenzer.pro');
define('LICENZER_TOKEN', 'YOUR_RESELLER_TOKEN_HERE');
```

## استفاده

### اجرای مستقیم

```bash
php licenzer.php
```

### استفاده در کد PHP

```php
<?php
require_once 'licenzer.php';

// استفاده از API
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

// دریافت لیست لایسنس‌ها
$licenses = $api->getLicenses();

// ثبت لایسنس جدید
$result = $api->registerLicense('192.168.1.100', 1, 'software_key');

// تغییر IP
$result = $api->changeIp('192.168.1.100', '192.168.1.101', 'software_key');

// دریافت اطلاعات لایسنس
$info = $api->getLicenseInfo('192.168.1.100', 'software_key');

// دریافت لایسنس‌های تخفیف‌دار
$discountLicenses = $api->getDiscountLicenses();
?>
```

## متدهای موجود

### `registerLicense($ip, $month, $softwareKey = null)`
ثبت لایسنس جدید
- `$ip`: آدرس IP
- `$month`: تعداد ماه (پیش‌فرض: 1)
- `$softwareKey`: کلید نرم‌افزار (اختیاری)

### `activateLicense($ip, $softwareKey)`
فعال‌سازی لایسنس

### `deactivateLicense($ip, $softwareKey)`
غیرفعال‌سازی لایسنس

### `deleteLicense($ip, $softwareKey)`
حذف لایسنس

### `changeIp($ip, $newIp, $softwareKey)`
تغییر IP لایسنس

### `getLicenseInfo($ip, $softwareKey)`
دریافت اطلاعات لایسنس

### `getLicenses()`
دریافت لیست تمام لایسنس‌ها

### `getDiscountLicenses($softwareKey = null)`
دریافت لایسنس‌های تخفیف‌دار

### `getSoftwares()`
دریافت لیست نرم‌افزارهای موجود

### `getBalance()`
دریافت موجودی حساب نمایندگی

### `testConnection()`
تست اتصال به API

## مثال‌های استفاده

### مثال 1: دریافت آمار

```php
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

$licenses = $api->getLicenses();
if (isset($licenses['status']) && $licenses['status'] == 'success') {
    $licenseList = $licenses['data'] ?? [];
    echo "Total: " . count($licenseList) . "\n";
}

$balance = $api->getBalance();
if (isset($balance['status']) && $balance['status'] == 'success') {
    echo "Balance: $" . number_format($balance['data'] ?? 0, 2) . "\n";
}
```

### مثال 2: ثبت لایسنس جدید

```php
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

$result = $api->registerLicense('192.168.1.100', 1, 'software_key');
if (isset($result['status']) && $result['status'] == 'success') {
    echo "License Key: " . $result['data']['license_key'] . "\n";
} else {
    echo "Error: " . $result['message'] . "\n";
}
```

### مثال 3: تغییر IP

```php
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

$result = $api->changeIp('192.168.1.100', '192.168.1.101', 'software_key');
if (isset($result['status']) && $result['status'] == 'success') {
    echo "IP changed successfully!\n";
} else {
    echo "Error: " . $result['message'] . "\n";
}
```

### مثال 4: دریافت اطلاعات لایسنس

```php
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

$result = $api->getLicenseInfo('192.168.1.100', 'software_key');
if (isset($result['status']) && $result['status'] == 'success') {
    $data = $result['data'];
    echo "License Key: " . $data['license_key'] . "\n";
    echo "IP: " . $data['ip'] . "\n";
    echo "Status: " . ($data['status'] ? 'Active' : 'Inactive') . "\n";
    echo "Expiry: " . $data['end_at'] . "\n";
}
```

### مثال 5: دریافت لایسنس‌های تخفیف‌دار

```php
$api = new LicenzerAPI(LICENZER_API_URL, LICENZER_TOKEN);

$discountLicenses = $api->getDiscountLicenses();
if (isset($discountLicenses['status']) && $discountLicenses['status'] == 'success') {
    foreach ($discountLicenses['data'] ?? [] as $license) {
        echo "License: " . $license['license_key'] . "\n";
        echo "Price: $" . number_format($license['price'], 2) . "\n";
        echo "Original: $" . number_format($license['original_price'], 2) . "\n";
        echo "---\n";
    }
}
```

## نیازمندی‌ها

- PHP 7.2 یا بالاتر
- cURL extension
- دسترسی به API سیستم LicenZer
- توکن نمایندگی معتبر

## خطاها

در صورت بروز خطا، پاسخ به صورت زیر خواهد بود:

```php
[
    'status' => 'error',
    'message' => 'Error message here'
]
```

در صورت موفقیت:

```php
[
    'status' => 'success',
    'data' => [...],
    'message' => 'Success message'
]
```

## نکات امنیتی

1. هرگز توکن نمایندگی را در کد commit نکنید
2. از متغیرهای محیطی یا فایل‌های تنظیمات خارج از public استفاده کنید
3. در صورت استفاده در وب، از HTTPS استفاده کنید
4. دسترسی به فایل را محدود کنید

## پشتیبانی

برای پشتیبانی و سوالات:
- Email: support@licenzer.pro
- Website: https://licenzer.pro

