<?php
/**
 * LicenZer Admin Discount Licenses Template
 */

require_once __DIR__ . '/../helper.php';

$api = new LicenZerAPIHelper($apiUrl, $resellerToken);

// Handle assign action
if ($_POST['action'] ?? '' == 'assign_discount') {
    $result = $api->assignDiscountLicense($_POST['license_key'], $_POST['service_id'], $_POST['new_ip'] ?? '');
    if ($result['success']) {
        echo '<div class="alert alert-success">Discount license assigned successfully!</div>';
    } else {
        echo '<div class="alert alert-danger">' . htmlspecialchars($result['message']) . '</div>';
    }
}

// Get discount licenses
$discountLicenses = $api->getDiscountLicenses();

// Get WHMCS services (all services, not just licenzer type)
use WHMCS\Database\Capsule;
$services = Capsule::table('tblhosting')
    ->select('tblhosting.*', 'tblproducts.name as product_name')
    ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
    ->where('tblhosting.domainstatus', '!=', 'Cancelled')
    ->get();

?>

<div class="licenzer-admin-discount">
    <div class="page-header">
        <h2>Discount Licenses</h2>
        <p>Manage previously activated licenses available at discounted prices (50% off, no setup cost)</p>
    </div>
    
    <div class="alert alert-info">
        <i class="fas fa-info-circle"></i>
        <strong>Discount Licenses:</strong> These are licenses that were previously activated and are now available for resale at 50% discount with no setup cost.
    </div>
    
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Available Discount Licenses</h3>
        </div>
        <div class="panel-body">
            <?php if (empty($discountLicenses)): ?>
                <div class="alert alert-warning">
                    No discount licenses available at this time.
                </div>
            <?php else: ?>
                <table class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>License Key</th>
                            <th>Software</th>
                            <th>IP Address</th>
                            <th>Original Price</th>
                            <th>Discount Price</th>
                            <th>Expiry Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($discountLicenses as $license): ?>
                        <tr>
                            <td><code><?php echo htmlspecialchars($license['license_key']); ?></code></td>
                            <td><?php echo htmlspecialchars($license['software_name']); ?></td>
                            <td><?php echo htmlspecialchars($license['ip']); ?></td>
                            <td><del>$<?php echo number_format($license['original_price'], 2); ?></del></td>
                            <td><strong style="color: #28a745;">$<?php echo number_format($license['price'], 2); ?></strong></td>
                            <td><?php echo htmlspecialchars($license['expiry_date']); ?></td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="assignLicense('<?php echo htmlspecialchars($license['license_key']); ?>', '<?php echo htmlspecialchars($license['ip']); ?>')">
                                    <i class="fas fa-check"></i> Assign to Service
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Assign License Modal -->
<div class="modal fade" id="assignLicenseModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post" action="<?php echo $modulelink; ?>&action=discount">
                <input type="hidden" name="action" value="assign_discount">
                <input type="hidden" name="license_key" id="assign_license_key">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Assign Discount License</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Select Service:</label>
                        <select name="service_id" class="form-control" required>
                            <option value="">-- Select Service --</option>
                            <?php foreach ($services as $service): ?>
                            <option value="<?php echo $service->id; ?>">
                                Service #<?php echo $service->id; ?> - <?php echo htmlspecialchars($service->domain ?: $service->product_name); ?> (<?php echo htmlspecialchars($service->product_name); ?>)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Current IP:</label>
                        <input type="text" class="form-control" id="assign_current_ip" readonly>
                    </div>
                    <div class="form-group">
                        <label>New IP Address (optional):</label>
                        <input type="text" name="new_ip" class="form-control" pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="Leave empty to keep current IP">
                        <small class="form-text text-muted">If you want to change the IP address when assigning</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Assign License</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function assignLicense(licenseKey, currentIp) {
    document.getElementById('assign_license_key').value = licenseKey;
    document.getElementById('assign_current_ip').value = currentIp;
    $('#assignLicenseModal').modal('show');
}
</script>

