<?php
/**
 * LicenZer Admin View License Template
 */

require_once __DIR__ . '/../helper.php';

$api = new LicenZerAPIHelper($apiUrl, $resellerToken);
$licenseKey = $_GET['license_key'] ?? '';

if (empty($licenseKey)) {
    echo '<div class="alert alert-danger">License key is required</div>';
    return;
}

// Get license info
$licenses = $api->getAllLicenses();
$licenseInfo = null;

foreach ($licenses as $license) {
    if (isset($license['license_key']) && $license['license_key'] == $licenseKey) {
        $licenseInfo = $license;
        break;
    }
}

if (!$licenseInfo) {
    echo '<div class="alert alert-danger">License not found</div>';
    return;
}

// Get full license info
$fullInfo = $api->getLicenseInfo($licenseKey);

?>

<div class="licenzer-admin-view-license">
    <div class="page-header">
        <h2>License Details</h2>
        <a href="<?php echo $modulelink; ?>&action=licenses" class="btn btn-default">
            <i class="fas fa-arrow-left"></i> Back to Licenses
        </a>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">License Information</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered">
                        <tr>
                            <th>License Key:</th>
                            <td><code><?php echo htmlspecialchars($licenseInfo['license_key']); ?></code></td>
                        </tr>
                        <tr>
                            <th>IP Address:</th>
                            <td><?php echo htmlspecialchars($licenseInfo['ip']); ?></td>
                        </tr>
                        <tr>
                            <th>Software:</th>
                            <td><?php echo htmlspecialchars($licenseInfo['software_name'] ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                <span class="label label-<?php echo $licenseInfo['status'] ? 'success' : 'danger'; ?>">
                                    <?php echo $licenseInfo['status'] ? 'Active' : 'Inactive'; ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Expiry Date:</th>
                            <td><?php echo htmlspecialchars($licenseInfo['end_at'] ?? $licenseInfo['Expired date'] ?? 'N/A'); ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Actions</h3>
                </div>
                <div class="panel-body">
                    <button class="btn btn-warning btn-block" onclick="changeIp('<?php echo htmlspecialchars($licenseKey); ?>', '<?php echo htmlspecialchars($licenseInfo['ip']); ?>')">
                        <i class="fas fa-exchange-alt"></i> Change IP Address
                    </button>
                    <button class="btn btn-info btn-block" onclick="viewInstallCommand()">
                        <i class="fas fa-terminal"></i> View Installation Command
                    </button>
                </div>
            </div>
            
            <?php if (isset($fullInfo['cmd'])): ?>
            <div class="panel panel-default" id="installCommandPanel" style="display: none;">
                <div class="panel-heading">
                    <h3 class="panel-title">Installation Command</h3>
                </div>
                <div class="panel-body">
                    <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><?php echo htmlspecialchars($fullInfo['cmd']); ?></pre>
                    <button class="btn btn-sm btn-primary" onclick="copyToClipboard('<?php echo htmlspecialchars(addslashes($fullInfo['cmd'])); ?>')">
                        <i class="fas fa-copy"></i> Copy Command
                    </button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Change IP Modal -->
<div class="modal fade" id="changeIpModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post" action="<?php echo $modulelink; ?>&action=licenses">
                <input type="hidden" name="action" value="change_ip">
                <input type="hidden" name="license_key" id="modal_license_key">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Change IP Address</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Current IP:</label>
                        <input type="text" class="form-control" id="modal_current_ip" readonly>
                    </div>
                    <div class="form-group">
                        <label>New IP Address:</label>
                        <input type="text" name="new_ip" class="form-control" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Change IP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function changeIp(licenseKey, currentIp) {
    document.getElementById('modal_license_key').value = licenseKey;
    document.getElementById('modal_current_ip').value = currentIp;
    $('#changeIpModal').modal('show');
}

function viewInstallCommand() {
    $('#installCommandPanel').toggle();
}

function copyToClipboard(text) {
    var textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();
    try {
        document.execCommand('copy');
        alert('Command copied to clipboard!');
    } catch (err) {
        alert('Failed to copy command');
    }
    document.body.removeChild(textarea);
}
</script>

