<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * LicenZer Module Installer
 * 
 * NOTE: This installer has been moved to the Addon Module.
 * The installer is now located at: modules/addons/licenzer/templates/admin_installer.php
 * 
 * This file is kept for backward compatibility but is no longer used.
 * Please use the Addon Module installer instead.
 * 
 * @deprecated Use Addon Module installer instead
 */

function licenzer_installer()
{
    // Check if already installed
    $existing = Capsule::table('tbladdonmodules')
        ->where('module', 'licenzer')
        ->where('setting', 'installed')
        ->first();
    
    if ($existing && $existing->value == '1') {
        // Show configuration page
        return licenzer_showConfig();
    }
    
    // Show installer
    return licenzer_showInstaller();
}

function licenzer_showInstaller()
{
    $output = '<div class="alert alert-info">';
    $output .= '<h3>LicenZer Module Installation</h3>';
    $output .= '<p>Welcome to LicenZer WHMCS Module installer. Please configure the following settings:</p>';
    $output .= '</div>';
    
    $output .= '<form method="post" action="configservers.php?action=save">';
    $output .= '<input type="hidden" name="module" value="licenzer">';
    $output .= '<input type="hidden" name="action" value="install">';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Reseller Token <span class="text-danger">*</span></label>';
    $output .= '<input type="text" name="reseller_token" class="form-control" required placeholder="Enter your LicenZer reseller token">';
    $output .= '<small class="form-text text-muted">You can find your token in your LicenZer reseller panel</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>API URL <span class="text-danger">*</span></label>';
    $output .= '<input type="text" name="api_url" class="form-control" required placeholder="https://licenzer.pro" value="' . (isset($_POST['api_url']) ? htmlspecialchars($_POST['api_url']) : 'https://licenzer.pro') . '">';
    $output .= '<small class="form-text text-muted">Base URL of your LicenZer installation</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Allow IP Change by Client</label>';
    $output .= '<select name="allow_ip_change" class="form-control">';
    $output .= '<option value="yes">Yes</option>';
    $output .= '<option value="no" selected>No</option>';
    $output .= '</select>';
    $output .= '<small class="form-text text-muted">Allow clients to change license IP address</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Maximum IP Changes</label>';
    $output .= '<input type="number" name="max_ip_changes" class="form-control" value="0" min="0">';
    $output .= '<small class="form-text text-muted">Maximum number of IP changes allowed (0 = unlimited)</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Enable Discount Licenses</label>';
    $output .= '<select name="enable_discount" class="form-control">';
    $output .= '<option value="yes">Yes</option>';
    $output .= '<option value="no" selected>No</option>';
    $output .= '</select>';
    $output .= '<small class="form-text text-muted">Enable discount licenses group (previously activated licenses)</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Auto-Add Products to WHMCS</label>';
    $output .= '<select name="auto_add_products" class="form-control">';
    $output .= '<option value="yes">Yes</option>';
    $output .= '<option value="no" selected>No</option>';
    $output .= '</select>';
    $output .= '<small class="form-text text-muted">Automatically add available software as products in WHMCS</small>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<button type="submit" class="btn btn-primary">Install & Configure</button>';
    $output .= '</div>';
    
    $output .= '</form>';
    
    return $output;
}

function licenzer_showConfig()
{
    $settings = array();
    $configs = Capsule::table('tbladdonmodules')
        ->where('module', 'licenzer')
        ->get();
    
    foreach ($configs as $config) {
        $settings[$config->setting] = $config->value;
    }
    
    $output = '<div class="alert alert-success">';
    $output .= '<h3>LicenZer Module Configuration</h3>';
    $output .= '<p>The module is installed and configured.</p>';
    $output .= '</div>';
    
    $output .= '<form method="post" action="configservers.php?action=save">';
    $output .= '<input type="hidden" name="module" value="licenzer">';
    $output .= '<input type="hidden" name="action" value="update">';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Reseller Token</label>';
    $output .= '<input type="text" name="reseller_token" class="form-control" value="' . htmlspecialchars($settings['reseller_token'] ?? '') . '">';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>API URL</label>';
    $output .= '<input type="text" name="api_url" class="form-control" value="' . htmlspecialchars($settings['api_url'] ?? '') . '">';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Allow IP Change by Client</label>';
    $output .= '<select name="allow_ip_change" class="form-control">';
    $output .= '<option value="yes"' . (($settings['allow_ip_change'] ?? 'no') == 'yes' ? ' selected' : '') . '>Yes</option>';
    $output .= '<option value="no"' . (($settings['allow_ip_change'] ?? 'no') == 'no' ? ' selected' : '') . '>No</option>';
    $output .= '</select>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Maximum IP Changes</label>';
    $output .= '<input type="number" name="max_ip_changes" class="form-control" value="' . htmlspecialchars($settings['max_ip_changes'] ?? '0') . '" min="0">';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<label>Enable Discount Licenses</label>';
    $output .= '<select name="enable_discount" class="form-control">';
    $output .= '<option value="yes"' . (($settings['enable_discount'] ?? 'no') == 'yes' ? ' selected' : '') . '>Yes</option>';
    $output .= '<option value="no"' . (($settings['enable_discount'] ?? 'no') == 'no' ? ' selected' : '') . '>No</option>';
    $output .= '</select>';
    $output .= '</div>';
    
    $output .= '<div class="form-group">';
    $output .= '<button type="submit" class="btn btn-primary">Update Configuration</button>';
    $output .= '<a href="configservers.php?action=addproduct" class="btn btn-success ml-2">Add Products to WHMCS</a>';
    $output .= '</div>';
    
    $output .= '</form>';
    
    return $output;
}

// Hook to show installer on module activation
add_hook('AdminAreaPage', 1, function($vars) {
    if ($vars['filename'] == 'configservers' && isset($_GET['module']) && $_GET['module'] == 'licenzer') {
        if (!isset($_GET['action']) || $_GET['action'] == 'install') {
            return licenzer_installer();
        }
    }
});

