<?php
/**
 * Settings page
 */

if (!current_user_can('manage_options')) {
    wp_die(__('You do not have sufficient permissions to access this page.'));
}

// Handle form submission
if (isset($_POST['submit']) && wp_verify_nonce($_POST['licenzer_settings_nonce'], 'licenzer_settings')) {
    update_option('licenzer_api_url', sanitize_text_field($_POST['licenzer_api_url']));
    update_option('licenzer_reseller_token', sanitize_text_field($_POST['licenzer_reseller_token']));
    update_option('licenzer_allow_ip_change', sanitize_text_field($_POST['licenzer_allow_ip_change']));
    update_option('licenzer_max_ip_changes', intval($_POST['licenzer_max_ip_changes']));
    update_option('licenzer_enable_discount', sanitize_text_field($_POST['licenzer_enable_discount']));
    
    echo '<div class="notice notice-success"><p>' . __('Settings saved successfully!', 'licenzer') . '</p></div>';
}

$api_url = get_option('licenzer_api_url', LICENZER_API_URL);
$reseller_token = get_option('licenzer_reseller_token', '');
$allow_ip_change = get_option('licenzer_allow_ip_change', 'no');
$max_ip_changes = get_option('licenzer_max_ip_changes', '0');
$enable_discount = get_option('licenzer_enable_discount', 'no');

// Test connection
$api = new Licenzer_API();
$connection_status = $api->testConnection();

?>
<div class="wrap licenzer-settings">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <form method="post" action="">
        <?php wp_nonce_field('licenzer_settings', 'licenzer_settings_nonce'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="licenzer_api_url"><?php _e('API URL', 'licenzer'); ?></label>
                </th>
                <td>
                    <input type="text" name="licenzer_api_url" id="licenzer_api_url" 
                           value="<?php echo esc_attr($api_url); ?>" class="regular-text" required>
                    <p class="description"><?php _e('Base URL of your LicenZer installation (without trailing slash)', 'licenzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="licenzer_reseller_token"><?php _e('Reseller Token', 'licenzer'); ?></label>
                </th>
                <td>
                    <input type="text" name="licenzer_reseller_token" id="licenzer_reseller_token" 
                           value="<?php echo esc_attr($reseller_token); ?>" class="regular-text" required>
                    <p class="description"><?php _e('Your LicenZer reseller token (found in your reseller panel profile)', 'licenzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="licenzer_allow_ip_change"><?php _e('Allow IP Change by Client', 'licenzer'); ?></label>
                </th>
                <td>
                    <select name="licenzer_allow_ip_change" id="licenzer_allow_ip_change">
                        <option value="yes" <?php selected($allow_ip_change, 'yes'); ?>><?php _e('Yes', 'licenzer'); ?></option>
                        <option value="no" <?php selected($allow_ip_change, 'no'); ?>><?php _e('No', 'licenzer'); ?></option>
                    </select>
                    <p class="description"><?php _e('Allow clients to change license IP address from their account', 'licenzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="licenzer_max_ip_changes"><?php _e('Maximum IP Changes', 'licenzer'); ?></label>
                </th>
                <td>
                    <input type="number" name="licenzer_max_ip_changes" id="licenzer_max_ip_changes" 
                           value="<?php echo esc_attr($max_ip_changes); ?>" min="0" class="small-text">
                    <p class="description"><?php _e('Maximum number of IP changes allowed per license (0 = unlimited)', 'licenzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="licenzer_enable_discount"><?php _e('Enable Discount Licenses', 'licenzer'); ?></label>
                </th>
                <td>
                    <select name="licenzer_enable_discount" id="licenzer_enable_discount">
                        <option value="yes" <?php selected($enable_discount, 'yes'); ?>><?php _e('Yes', 'licenzer'); ?></option>
                        <option value="no" <?php selected($enable_discount, 'no'); ?>><?php _e('No', 'licenzer'); ?></option>
                    </select>
                    <p class="description"><?php _e('Enable discount licenses group (previously activated licenses available at 50% discount)', 'licenzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php _e('API Status', 'licenzer'); ?></th>
                <td>
                    <?php if ($connection_status): ?>
                        <span class="status-badge status-active"><?php _e('Connected', 'licenzer'); ?></span>
                    <?php else: ?>
                        <span class="status-badge status-inactive"><?php _e('Disconnected', 'licenzer'); ?></span>
                        <p class="description"><?php _e('Please check your API URL and Reseller Token', 'licenzer'); ?></p>
                    <?php endif; ?>
                </td>
            </tr>
        </table>

        <?php submit_button(); ?>
    </form>
</div>

