<?php
/**
 * Fired during plugin activation
 */
class Licenzer_Activator {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     */
    public static function activate() {
        // Set default options
        if (!get_option('licenzer_api_url')) {
            add_option('licenzer_api_url', LICENZER_API_URL);
        }

        if (!get_option('licenzer_reseller_token')) {
            add_option('licenzer_reseller_token', '');
        }

        if (!get_option('licenzer_allow_ip_change')) {
            add_option('licenzer_allow_ip_change', 'no');
        }

        if (!get_option('licenzer_max_ip_changes')) {
            add_option('licenzer_max_ip_changes', '0');
        }

        if (!get_option('licenzer_enable_discount')) {
            add_option('licenzer_enable_discount', 'no');
        }

        // Create database tables if needed
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        $table_name = $wpdb->prefix . 'licenzer_licenses';
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            user_id bigint(20) NOT NULL,
            license_key varchar(255) NOT NULL,
            ip_address varchar(45) NOT NULL,
            software_key varchar(100) NOT NULL,
            software_name varchar(255) DEFAULT NULL,
            status tinyint(1) DEFAULT 1,
            expiry_date date DEFAULT NULL,
            ip_changes int(11) DEFAULT 0,
            max_ip_changes int(11) DEFAULT 0,
            is_discount tinyint(1) DEFAULT 0,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            KEY user_id (user_id),
            KEY license_key (license_key)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}

