<?php
/**
 * Plugin Name: LicenZer License Manager
 * Plugin URI: https://licenzer.pro
 * Description: Sell and manage LicenZer licenses directly from your WordPress site. Integrate with WooCommerce or use standalone license management.
 * Version: 1.0.0
 * Author: LicenZer
 * Author URI: https://licenzer.pro
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: licenzer
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.2
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 */
define('LICENZER_VERSION', '1.0.0');
define('LICENZER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('LICENZER_PLUGIN_URL', plugin_dir_url(__FILE__));
define('LICENZER_API_URL', 'https://licenzer.pro');

/**
 * The code that runs during plugin activation.
 */
function activate_licenzer() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-licenzer-activator.php';
    Licenzer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_licenzer() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-licenzer-deactivator.php';
    Licenzer_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_licenzer');
register_deactivation_hook(__FILE__, 'deactivate_licenzer');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-licenzer.php';

/**
 * Begins execution of the plugin.
 */
function run_licenzer() {
    $plugin = new Licenzer();
    $plugin->run();
}
run_licenzer();

