<?php
/**
 * Change IP Form Template
 */

$license_key = !empty($atts['license_key']) ? $atts['license_key'] : '';
?>

<div class="licenzer-change-ip-form">
    <h2><?php _e('Change License IP Address', 'licenzer'); ?></h2>
    
    <?php if (get_option('licenzer_allow_ip_change') != 'yes'): ?>
        <p class="licenzer-error"><?php _e('IP change is not allowed for your account.', 'licenzer'); ?></p>
        <?php return; ?>
    <?php endif; ?>

    <form id="licenzer-change-ip-form" method="post">
        <?php wp_nonce_field('licenzer_change_ip', 'licenzer_change_ip_nonce'); ?>
        
        <input type="hidden" name="action" value="licenzer_change_ip">
        
        <p>
            <label for="license_key"><?php _e('License Key', 'licenzer'); ?></label>
            <input type="text" name="license_key" id="license_key" 
                   value="<?php echo esc_attr($license_key); ?>" 
                   class="regular-text" required>
        </p>
        
        <p>
            <label for="new_ip"><?php _e('New IP Address', 'licenzer'); ?></label>
            <input type="text" name="new_ip" id="new_ip" 
                   class="regular-text" required 
                   pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" 
                   placeholder="192.168.1.1">
            <span class="description"><?php _e('Enter the new IP address for your license', 'licenzer'); ?></span>
        </p>
        
        <p class="submit">
            <button type="submit" class="button button-primary">
                <?php _e('Change IP', 'licenzer'); ?>
            </button>
        </p>
    </form>
    
    <div id="licenzer-change-ip-result"></div>
</div>

